/******************************************************************************
 * (C) Copyright 1999 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xobsdefs.h
 *       observer definitions
 * -----------------------------------------------------------------*/

#ifndef XOBSDEFS_H_INCLUDED                               
#define XOBSDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif

/* ---------------------------------------------------------------
 * Type Definitions for Observer Functions
 * --------------------------------------------------------------- */

#define BX_OBSRULEPROP_SIZE 53       /* fix number of rules for Mephisto-based HW */
#define BX_OBSRULEPROP_DW            ((BX_OBSRULEPROP_SIZE+31)/32)   /* number of DW needed for bx_obsruletype (Mephisto only) */
#define BX_OBSRULEPROP_SIZE30 57     /* number of entries in bx_obsruletype */
#define BX_OBSRULEPROP_DW30          ((BX_OBSRULEPROP_SIZE30+31)/32)   /* number of DW needed for bx_obsruletype */

CLI typedef enum{
  BX_OBSRULE_INITIATOR_0,  /* @initiator_0 */  /* bit 0  */
  BX_OBSRULE_INITIATOR_1,  /* @initiator_1 */  /* bit 1  */
  BX_OBSRULE_INITIATOR_2,  /* @initiator_2 */  /* bit 2  */
  BX_OBSRULE_INITIATOR_3,  /* @initiator_3 */  /* bit 3  */
  BX_OBSRULE_TARGET_0,     /* @target_0    */  /* bit 4  */
  BX_OBSRULE_TARGET_1,     /* @target_1    */  /* bit 5  */
  BX_OBSRULE_TARGET_2,     /* @target_2    */  /* bit 6  */
  BX_OBSRULE_TARGET_3,     /* @target_3    */  /* bit 7  */
  BX_OBSRULE_TARGET_4,     /* @target_4    */  /* bit 8  */
  BX_OBSRULE_TARGET_5,     /* @target_5    */  /* bit 9  */
  BX_OBSRULE_TARGET_6,     /* @target_6    */  /* bit 10 */
  BX_OBSRULE_FRAME_0,      /* @frame_0     */  /* bit 11 */
  BX_OBSRULE_FRAME_1,      /* @frame_1     */  /* bit 12 */
  BX_OBSRULE_IRDY_0,       /* @irdy_0      */  /* bit 13 */
  BX_OBSRULE_IRDY_1,       /* @irdy_1      */  /* bit 14 */
  BX_OBSRULE_IRDY_2,       /* @irdy_2      */  /* bit 15 */
  BX_OBSRULE_IRDY_3,       /* @irdy_3      */  /* bit 16 */
  BX_OBSRULE_TRDY_0,       /* @trdy_0      */  /* bit 17 */
  BX_OBSRULE_TRDY_1,       /* @trdy_1      */  /* bit 18 */
  BX_OBSRULE_DEVSEL_0,     /* @devsel_0    */  /* bit 19 */
  BX_OBSRULE_DEVSEL_1,     /* @devsel_1    */  /* bit 20 */
  BX_OBSRULE_DEVSEL_2,     /* @devsel_2    */  /* bit 21 */
  BX_OBSRULE_DEVSEL_3,     /* @devsel_3    */  /* bit 22 */
  BX_OBSRULE_DEVSEL_4,     /* @devsel_4    */  /* bit 23 */
  BX_OBSRULE_STOP_0,       /* @stop_0      */  /* bit 24 */
  BX_OBSRULE_LAT_0,        /* @lat_0       */  /* bit 25 */
  BX_OBSRULE_LAT_1,        /* @lat_1       */  /* bit 26 */
  BX_OBSRULE_W64_0,        /* @w64_0       */  /* bit 27 */
  BX_OBSRULE_W64_1,        /* @w64_1       */  /* bit 28 */
  BX_OBSRULE_W64_2,        /* @w64_2       */  /* bit 29 */
  BX_OBSRULE_W64_3,        /* @w64_3       */  /* bit 30 */
  BX_OBSRULE_W64_4,        /* @w64_4       */  /* bit 31 */
  BX_OBSRULE_PAR_0,        /* @par_0       */  /* bit 32 */
  BX_OBSRULE_PAR_1,        /* @par_1       */  /* bit 33 */
  BX_OBSRULE_PAR_2,        /* @par_2       */  /* bit 34 */
  BX_OBSRULE_PAR_3,        /* @par_3       */  /* bit 35 */
  BX_OBSRULE_PAR_4,        /* @par_4       */  /* bit 36 */
  BX_OBSRULE_PAR_5,        /* @par_5       */  /* bit 37 */
  BX_OBSRULE_PAR_6,        /* @par_6       */  /* bit 38 */
  BX_OBSRULE_SEM_0,        /* @sem_0       */  /* bit 39 */
  BX_OBSRULE_SEM_1,        /* @sem_1       */  /* bit 40 */
  BX_OBSRULE_SEM_2,        /* @sem_2       */  /* bit 41 */
  BX_OBSRULE_SEM_3,        /* @sem_3       */  /* bit 42 */
  BX_OBSRULE_SEM_4,        /* @sem_4       */  /* bit 43 */
  BX_OBSRULE_SEM_5,        /* @sem_5       */  /* bit 44 */
  BX_OBSRULE_SEM_6,        /* @sem_6       */  /* bit 45 */
  BX_OBSRULE_SEM_7,        /* @sem_7       */  /* bit 46 */
  BX_OBSRULE_SEM_8,        /* @sem_8       */  /* bit 47 */
  BX_OBSRULE_SEM_9,        /* @sem_9       */  /* bit 48 */
  BX_OBSRULE_SEM_10,       /* @sem_10      */  /* bit 49 */
  BX_OBSRULE_SEM_11,       /* @sem_11      */  /* bit 50 */
  BX_OBSRULE_SEM_12,       /* @sem_12      */  /* bit 51 */
  BX_OBSRULE_SEM_13,       /* @sem_13      */  /* bit 52 */
  BX_OBSRULE_ECC_0,        /* @ecc_0       */  /* bit 53 */
  BX_OBSRULE_ECC_1,        /* @ecc_1       */  /* bit 54 */
  BX_OBSRULE_ECC_2,        /* @ecc_2       */  /* bit 55 */
  BX_OBSRULE_ECC_3         /* @ecc_3       */  /* bit 56 */
} bx_obsruletype;


/* The dyncaps entry defaultval determines,
   when the corresponding rule is valid (i.e. may trigger).
   Its either a Mephisto, mode1 and/or mode2 rule. 
*/
#define BX_OBS_MASK_MEPHISTO   0x1
#define BX_OBS_MASK_MODE1      0x2
#define BX_OBS_MASK_MODE2      0x4

typedef enum {
    BX_OBS_BSTATE_NOSYNC,
    BX_OBS_BSTATE_IDLE,
    BX_OBS_BSTATE_DAC1,
    BX_OBS_BSTATE_ADDR,
    BX_OBS_BSTATE_DAC2,
    BX_OBS_BSTATE_ATTR,
    BX_OBS_BSTATE_TRGRES,
    BX_OBS_BSTATE_WAIT,
    BX_OBS_BSTATE_TRANSFER,
    BX_OBS_BSTATE_RECOVER,
    BX_OBS_BSTATE_DECODING,
    BX_OBS_BSTATE_TERM
} bx_obsbstatetype;

typedef enum { 
    BX_OBS_TERM_NONE,
    BX_OBS_TERM_IABORT,
    BX_OBS_TERM_SPLIT_RESPONSE,
    BX_OBS_TERM_TABORT,
    BX_OBS_TERM_DISCONNECT_SDP,
    BX_OBS_TERM_RETRY,
    BX_OBS_TERM_DISCONNECT_ADB,
    BX_OBS_TERM_COMPLETION
} bx_obstermtype;


typedef enum {
  BX_OBS_CMD_INTACK,
  BX_OBS_CMD_SCYCLE,
  BX_OBS_CMD_IOREAD,
  BX_OBS_CMD_IOWRITE,
  BX_OBS_CMD_RESERVED1,
  BX_OBS_CMD_RESERVED2,
  BX_OBS_CMD_MEMREADDWORD,
  BX_OBS_CMD_MEMWRITE,
  BX_OBS_CMD_ALIASMEMREADBLOCK,
  BX_OBS_CMD_ALIASMEMWRITEBLOCK,
  BX_OBS_CMD_CONFIGREAD,
  BX_OBS_CMD_CONFIGWRITE,
  BX_OBS_CMD_SPLITCOMPLETION,
  BX_OBS_CMD_DUALADDRCYCLE,
  BX_OBS_CMD_MEMREADBLOCK,
  BX_OBS_CMD_MEMWRITEBLOCK
} bx_obscmdtype;

#endif


